<?php
/**
 * Parallel PO main controller
 * 
 * @package blesta
 * @subpackage blesta.plugins.parallel_po
 * @copyright Copyright (c) 2010, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */
class AdminMain extends AppController {
	
	/**
	 * Pre action
	 */
	public function preAction() {
		parent::preAction();

		// Override default view directory
		$this->view->view = "default";
		// Restore structure view
		$this->structure->setDefaultView(APPDIR);
		
		$this->requireLogin();
		
		Language::loadLang("admin_main", null, PLUGINDIR . "parallel_po" . DS . "language" . DS);
	}

	/**
	 * Index
	 */
	public function index() {
		$ips = array('' => "-- Please Select --");
		$limit = 100;
		
		$this->uses(array("SystemOverview.SystemOverviewUsers"));
		$users = $this->SystemOverviewUsers->getRecentUsers(Configure::get("Blesta.company_id"), $limit);

		foreach ($users as $user) {
			$ips[$user->ip_address] = $user->first_name . " " . $user->last_name . " (" . $user->ip_address . ")";
		}
		
		$this->set("ips", $ips);
	}
	
	public function getDns() {
		$ip = $this->get['ip'];
		$host = $ip;
		try {
			$host = gethostbyaddr($ip);
		}
		catch (Exception $e) {
			// nothing to do
		}
		
		#
		# TODO: lookup lat/lng for the given IP
		#
			
		echo json_encode(array('host' => $host));
		return false;
	}
}
?>